/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.adapter;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import dev.toma.gunsrpg.resource.crate.LootConfig;
import dev.toma.gunsrpg.resource.crate.LootConfigurationCategory;
import dev.toma.gunsrpg.resource.crate.LootEntry;
import dev.toma.gunsrpg.resource.crate.SlotConfiguration;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.JSONUtils;

public class LootConfigurationAdapter
implements JsonDeserializer<LootConfig> {
    public LootConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = JsonHelper.asJsonObject(json);
        JsonArray categoryArray = JSONUtils.func_151214_t((JsonObject)object, (String)"categories");
        LootConfigurationCategory[] categories = new LootConfigurationCategory[categoryArray.size()];
        for (int i = 0; i < categoryArray.size(); ++i) {
            JsonElement element = categoryArray.get(i);
            categories[i] = (LootConfigurationCategory)context.deserialize(element, LootConfigurationCategory.class);
        }
        JsonArray slotArray = JSONUtils.func_151214_t((JsonObject)object, (String)"slots");
        SlotConfiguration[] slots = new SlotConfiguration[slotArray.size()];
        for (int i = 0; i < slotArray.size(); ++i) {
            JsonElement element = slotArray.get(i);
            slots[i] = (SlotConfiguration)context.deserialize(element, SlotConfiguration.class);
        }
        JsonObject mappedPools = JSONUtils.func_152754_s((JsonObject)object, (String)"lootConfiguration");
        Set<String> keySet = mappedPools.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toSet());
        this.checkAllKeysContained(keySet, categories);
        HashMap<LootConfigurationCategory, List<LootEntry>> poolsByCategory = new HashMap<LootConfigurationCategory, List<LootEntry>>();
        for (LootConfigurationCategory category : categories) {
            JsonArray entries = JSONUtils.func_151214_t((JsonObject)mappedPools, (String)category.getIdentifier());
            ArrayList<Object> list = new ArrayList<Object>();
            for (JsonElement element : entries) {
                list.add(context.deserialize(element, LootEntry.class));
            }
            poolsByCategory.put(category, list);
        }
        return new LootConfig(slots, categories, poolsByCategory);
    }

    private void checkAllKeysContained(Set<String> keySet, LootConfigurationCategory[] categories) {
        HashSet<String> missing = new HashSet<String>();
        for (LootConfigurationCategory category : categories) {
            String key = category.getIdentifier();
            if (keySet.contains(key)) continue;
            missing.add(key);
        }
        if (!missing.isEmpty()) {
            throw new JsonSyntaxException(String.format("Missing loot pool definitions for keys [%s]", String.join((CharSequence)", ", missing)));
        }
    }
}

